ORCA/M Asm65816 2.1.0

0001 AB48                       TITLE '65SC816 Dissassembler'
0002 AB48
0003 AB48              ;	This EdAsm/Asm816 source code file was converted to AsmIIGS
0004 AB48              ;	by EdAsmCvtIIGS version 1.2d5 on 5/9/91 at 6:19:49 PM
0005 AB48
0006 AB48              ******************************************************
0007 AB48              *                                                    *
0008 AB48              *            Dissassembler for the 65SC816           *
0009 AB48              *                                                    *
0010 AB48              *                    by                              *
0011 AB48              *               Fern Bachman     1985-1987           *
0012 AB48              *               Joe Bo           1987-1989           *
0013 AB48              *                                                    *
0014 AB48              *     Developed from Ed Lai's 65SC816 disassembler   *
0015 AB48              *                                                    *
0016 AB48              *       Copyright Apple Computer, Inc. 1985-1989     *
0017 AB48              *                All Rights Reserved.                *
0018 AB48              *                                                    *
0019 AB48              ******************************************************
0020 AB48              *
0021 AB48              * The CHKWAIT Routine was added (2/8/89 MSA) to ensure that
0022 AB48              *  Control-S keypresses would cause a pause.  Because of the
0023 AB48              *  implementation of the video firmware, ctrl-s is not always
0024 AB48              *  seen when the event manager is active.  This routine checks
0025 AB48              *  to see if the EM is active and if active gets the key from
0026 AB48              *  there.  If inactive it tries to get one from $C000.
0027 AB48              *
0028 AB48              CHKWAIT  EQU   *
0029 AB48 48                    PHA                            ;Preserve
0030 AB49 20 74 CF              JSR   XRDKBD                   ;Get a key from EM or $C000
0031 AB4C 10 0B                 BPL   @1
0032 AB4E 29 7F                 AND   #$7F
0033 AB50 C9 13                 CMP   #$13
0034 AB52 D0 05                 BNE   @1
0035 AB54              @2       EQU   *
0036 AB54 20 74 CF              JSR   XRDKBD
0037 AB57 10 FB                 BPL   @2
0038 AB59              @1       EQU   *
0039 AB59 68                    PLA   
0040 AB5A 60                    RTS   
0041 AB5B              *
0042 AB5B              *
0043 AB5B              LISTFF   EQU   *
0044 AB5B 20 62 FE              JSR   A1PC
0045 AB5E AF 30 01 E1           LDA   >MPVAL                   ;Retrieve 'm' status
0046 AB62 A2 ED                 LDX   #'m'                     ;Show user 'm'
0047 AB64 20 0D AE              JSR   PRAEQX                   ;Print A (in ASCII) = X (in HEX)
0048 AB67 AF 31 01 E1           LDA   >XPVAL                   ;Retrieve 'x' status
0049 AB6B A2 F8                 LDX   #'x'                     ;Show user 'x'
0050 AB6D 20 0D AE              JSR   PRAEQX                   ;Print A (in ASCII) = X (in HEX)
0051 AB70 AF 33 01 E1           LDA   >DDVAL                   ;Retrieve 'd' status            
0052 AB74 A2 E4                 LDX   #'d'                     ;Show user 'd'
0053 AB76 20 0D AE              JSR   PRAEQX                   ;Print A (in ASCII) = X (in HEX)
0054 AB79 AF 2F 01 E1           LDA   >LVAL                    ;Retrieve LC bank status
0055 AB7D A2 CC                 LDX   #'L'                     ;Add 'k' to 'LCban'
0056 AB7F 20 0D AE              JSR   PRAEQX                   ;Print A (in ASCII) = X (in HEX)
0057 AB82 A9 07                 LDA   #CBANKMSG                ;Display 'Cbank (0/1)'
0058 AB84 20 80 C0              JSR   PRINTMSG                 ;
0059 AB87 20 52 AC              JSR   LIST3                    ;Next line please
0060 AB8A 38                    SEC                            ;Determine how many lines to display
0061 AB8B A5 23                 LDA   WNDBTM                   ;Bottom-top-4 = number of lines to show
0062 AB8D E5 22                 SBC   WNDTOP                   ;
0063 AB8F 38                    SEC                            ;
0064 AB90 E9 04                 SBC   #4                       ;
0065 AB92 10 05                 BPL   @1                       ;+ then enough lines available
0066 AB94 D0 03                 BNE   @1                       ;<>0 can't quit now
0067 AB96 4C 52 AC              JMP   LIST3                    ;Prepare to quit
0068 AB99
0069 AB99              @1       EQU   *
0070 AB99 20 48 AB              JSR   CHKWAIT                  ;Do a pause if ctrl-s is pressed
0071 AB9C 48                    PHA                            ;Save # counter on stack
0072 AB9D A0 00                 LDY   #0                       ;Prepare to look ahead
0073 AB9F 20 8B B4              JSR   READPCY                  ;Read an opcode
0074 ABA2 48                    PHA                            ;Save opcode
0075 ABA3 AF 33 01 E1           LDA   >DDVAL                   ;CHK for special disassembly required
0076 ABA7 D0 21                 BNE   @1_0                     ;BRA for ignoring REP/SEP stuffs
0077 ABA9 68                    PLA                            ;Get back opcode
0078 ABAA C9 C2                 CMP   #$C2                     ;REP code ?
0079 ABAC F0 50                 BEQ   @3                       ;BRA if yes
0080 ABAE C9 E2                 CMP   #$E2                     ;SEP code ?
0081 ABB0 D0 19                 BNE   @1_01                    ;BRA if not
0082 ABB2 20 8A B4              JSR   READPCY1                 ;Read next byte and test for 8 bit m/x
0083 ABB5 0A                    ASL   A                        ;Shift m/x to 'c'/'n'
0084 ABB6 0A                    ASL   A                        ;
0085 ABB7 0A                    ASL   A                        ;
0086 ABB8 10 06                 BPL   @4                       ;BRA if not setting 'x' to 8 bit mode
0087 ABBA A9 01                 LDA   #$01                     ;Set flags for MPVAL/XPVAL probably
0088 ABBC 8F 31 01 E1           STA   >XPVAL                   ;
0089 ABC0 90 52        @4       BCC   @1_22                    ;
0090 ABC2 A9 01                 LDA   #$01                     ;
0091 ABC4 8F 30 01 E1           STA   >MPVAL                   ;
0092 ABC8 80 4A                 BRA   @1_22                    ;
0093 ABCA
0094 ABCA 68           @1_0     PLA                            ;Get back opcode
0095 ABCB C9 22        @1_01    CMP   #$22                     ;JSL opcode
0096 ABCD F0 47                 BEQ   @2                       ;If JSL opcode see if PRODOS16 MLI call
0097 ABCF C9 20                 CMP   #$20                     ;Test for PRODOS8 MLI call
0098 ABD1 D0 41                 BNE   @1_22                    ;<>= then no PRODOS call
0099 ABD3 20 8A B4              JSR   READPCY1                 ;Read next byte
0100 ABD6 0F 3E 01 E1           ORA   >BANKS                   ;Source bank and byte=0 if MLI call
0101 ABDA D0 38                 BNE   @1_22                    ;
0102 ABDC 20 8A B4              JSR   READPCY1                 ;Read next byte
0103 ABDF C9 BF                 CMP   #>PRO8MLI                ;Hi byte of PRODOS8 MLI call address
0104 ABE1 D0 31                 BNE   @1_22                    ;
0105 ABE3
0106 ABE3 A3 01                 LDA   1,S                      ;See if enough room to show MLI code
0107 ABE5 C9 03                 CMP   #3                       ;Must have 3 or more lines to do this
0108 ABE7 90 46                 BCC   @1_5                     ;0,1,2 then not enough lines left
0109 ABE9 20 2C AD              JSR   DISASEM                  ;Disassemble JSR $BF00 instruction
0110 ABEC 20 7B AC              JSR   FIXPC                    ;Fix PCL/PCH
0111 ABEF 68                    PLA                            ;Decrement counter
0112 ABF0 3A                    DEC   A                        ;
0113 ABF1 48                    PHA                            ;Resave on stack
0114 ABF2 20 5D AC              JSR   DO1MLIDATA               ;Show line
0115 ABF5 A0 01                 LDY   #1                       ;
0116 ABF7              @1_1     EQU   *
0117 ABF7 20 5F AC              JSR   DOMLIDATA                ;Show line
0118 ABFA 68                    PLA                            ;Fix up counter
0119 ABFB 3A                    DEC   A                        ;-1 for DFB line
0120 ABFC 80 4C                 BRA   @1_4                     ;Done with MLI call so go for next line
0121 ABFE
0122 ABFE              @3       EQU   *
0123 ABFE 20 8A B4              JSR   READPCY1                 ;Read next byte and test for REP m/x
0124 AC01 0A                    ASL   A                        ;Shift m/x to 'c'/'n'
0125 AC02 0A                    ASL   A                        ;
0126 AC03 0A                    ASL   A                        ;
0127 AC04 10 06                 BPL   @3_1                     ;BRA if not set 'x' to 16 bit mode
0128 AC06 A9 00                 LDA   #$00                     ;Else set to 16 bit mode
0129 AC08 8F 31 01 E1           STA   >XPVAL                   ;Set it for disassembly
0130 AC0C              @3_1     EQU   *
0131 AC0C 90 35                 BCC   @1_2                     ;BRA if not set 'm' to 16 bit mode
0132 AC0E A9 00                 LDA   #$00                     ;
0133 AC10 8F 30 01 E1           STA   >MPVAL                   ;Else set it for disassembly routine
0134 AC14 80 2D        @1_22    BRA   @1_2                     ;Continue to disassembly
0135 AC16
0136 AC16              @2       EQU   *
0137 AC16 20 8A B4              JSR   READPCY1                 ;Read next byte and test for PRO16MLI addr
0138 AC19 C9 A8                 CMP   #<PRO16MLI               ;Test low byte for PRO16MLI first
0139 AC1B D0 26                 BNE   @1_2                     ;<>= then not a PRODOS 16 MLI call
0140 AC1D 20 8A B4              JSR   READPCY1                 ;Read next byte and test for PRO16MLI addr
0141 AC20 C9 00                 CMP   #>PRO16MLI               ;Test high byte for PRO16MLI call
0142 AC22 D0 1F                 BNE   @1_2                     ;<>= then not a PRODOS 16 MLI call
0143 AC24 20 8A B4              JSR   READPCY1                 ;Read next byte and test for PRO16MLI addr
0144 AC27 C9 E1                 CMP   #^PRO16MLI               ;Test bank byte for PRO16MLI call
0145 AC29 D0 18                 BNE   @1_2                     ;<>= then not a PRODOS 16 MLI call
0146 AC2B A3 01                 LDA   1,S                      ;Test lines left on scrn to see if enough
0147 AC2D C9 03                 CMP   #$03                     ;Need 3 lines
0148 AC2F 90 29        @1_5     BCC   DOMLI2                   ;0,1,2 then quit out of here
0149 AC31 20 2C AD              JSR   DISASEM                  ;Disassemble PRODOS 16 MLI JSL
0150 AC34 20 7B AC              JSR   FIXPC                    ;Alter saved program counter
0151 AC37 68                    PLA                            ;Alter stack count
0152 AC38 3A                    DEC   A                        ;
0153 AC39 48                    PHA                            ;Resave count for later
0154 AC3A A0 01                 LDY   #$01                     ;Print DW for PRODOS 16 MLI call
0155 AC3C 20 5F AC              JSR   DOMLIDATA                ;
0156 AC3F A0 03                 LDY   #$03                     ;Print DDW for PRODOS 16 MLI call
0157 AC41 80 B4                 BRA   @1_1                     ;
0158 AC43
0159 AC43              @1_2     EQU   *
0160 AC43 20 2C AD              JSR   DISASEM                  ;Disassemble unknown instruction
0161 AC46 20 7B AC              JSR   FIXPC
0162 AC49 68                    PLA   
0163 AC4A              @1_4     EQU   *
0164 AC4A 3A                    DEC   A                        ;Dec counter
0165 AC4B F0 05                 BEQ   LIST3                    ;=0 then done
0166 AC4D 30 03                 BMI   LIST3                    ;- then done
0167 AC4F 4C 99 AB              JMP   @1                       ;Continue on
0168 AC52
0169 AC52              LIST3    EQU   *
0170 AC52 20 48 AB              JSR   CHKWAIT                  ;Pause if ctrl-s is pressed
0171 AC55 20 CF A9              JSR   CROUTFF                  ;
0172 AC58 80 37                 BRA   PR1BLNKFF                ;Forces a new line with next JSR CROUTFF
0173 AC5A
0174 AC5A              DOMLI2   EQU   *
0175 AC5A 68                    PLA                            ;Quit if here
0176 AC5B 80 F5                 BRA   LIST3                    ; after cleaning up stack.
0177 AC5D
0178 AC5D              DO1MLIDATA EQU   *
0179 AC5D A0 00                 LDY   #$00                     ;# of bytes to show -1
0180 AC5F              DOMLIDATA EQU   *
0181 AC5F 5A                    PHY                            ;Save 'Y' value
0182 AC60 20 87 AC              JSR   PRPCADDR                 ;Print program ctr bank number/addr
0183 AC63 7A                    PLY                            ;Restore 'Y' value
0184 AC64 84 2F                 STY   LENGTH                   ;Tell disassembler how much data to show
0185 AC66 20 0D AD              JSR   DISASEM2                 ;Disassemble line
0186 AC69 A2 05                 LDX   #5                       ;Print 5 blanks
0187 AC6B 20 CA A9              JSR   PRBL2FF                  ;Print 'X' number of spaces
0188 AC6E A4 2F                 LDY   LENGTH                   ;Recall # of bytes-1 for operand
0189 AC70
0190 AC70              @1       EQU   *
0191 AC70 20 8B B4              JSR   READPCY                  ;Read byte
0192 AC73 5A                    PHY                            ;Save 'Y'
0193 AC74 20 A3 A9              JSR   PRBYTEFF                 ;Print byte
0194 AC77 7A                    PLY                            ;Recall 'Y'
0195 AC78 88                    DEY                            ;Next byte please
0196 AC79 10 F5                 BPL   @1                       ;Loop til all printed
0197 AC7B
0198 AC7B              FIXPC    EQU   *
0199 AC7B 20 53 F9              JSR   PCADJ                    ;A3=PC+LENGTH
0200 AC7E 85 3A                 STA   PCL
0201 AC80 84 3B                 STY   PCH
0202 AC82 85 40                 STA   A3L                      ;
0203 AC84 84 41                 STY   A3H                      ;
0204 AC86 60                    RTS                            ;Back to caller
0205 AC87
0206 AC87              PRPCADDR EQU   *
0207 AC87 20 86 A9              JSR   PRBANKS                  ;Print bank number
0208 AC8A A6 3A                 LDX   PCL                      ;print PCL,H
0209 AC8C A4 3B                 LDY   PCH
0210 AC8E 20 81 A9              JSR   XPRADDRFF                ;
0211 AC91              PR1BLNKFF EQU   *                       ;Print 1 blank routine
0212 AC91 A9 A0                 LDA   #$A0                     ;Space ASCII
0213 AC93 4C D1 A9              JMP   COUTFF                   ;Print ASCII value
0214 AC96
0215 AC96
0216 AC96              XINSDS1  EQU   *
0217 AC96 20 87 AC              JSR   PRPCADDR                 ;Print program ctr bank number/addr
0218 AC99 20 8B B4              JSR   READPCY
0219 AC9C              INSDS3   EQU   *
0220 AC9C 4A                    LSR   A                        ;EVEN/ODD TEST 
0221 AC9D 85 3F                 STA   A2H                      ;Save for immediate opcode testing
0222 AC9F A8                    TAY   
0223 ACA0 08                    PHP                            ;save odd even status
0224 ACA1 08                    PHP   
0225 ACA2 90 04                 BCC   @1
0226 ACA4 29 0F                 AND   #$0F                     ;MASK BITS 
0227 ACA6 09 80                 ORA   #$80
0228 ACA8 4A           @1       LSR   A                        ;LSB INTO CARRY FOR L/R TEST 
0229 ACA9 AA                    TAX   
0230 ACAA BF 24 AE FF           LDA   >FMT1,X                  ;GET FORMAT INDEX BYTE 
0231 ACAE 20 79 F8              JSR   SCRN2                    ;R/L H-BYTE ON CARRY 
0232 ACB1 28                    PLP                            ;get back odd even status
0233 ACB2 90 02                 BCC   @2
0234 ACB4 69 07                 ADC   #7                       ;extra 8 byte disp for odd
0235 ACB6 85 2E        @2       STA   FORMAT                   ;save index of the table
0236 ACB8 AA                    TAX   
0237 ACB9 E0 08                 CPX   #8                       ;If 8 then a 1 or 2 byte # instruction
0238 ACBB D0 16                 BNE   @5                       ;
0239 ACBD A5 3F                 LDA   A2H                      ;Recall LSR'ed opcode for testing
0240 ACBF 29 04                 AND   #$04                     ;Test 1 bit only
0241 ACC1 F0 06                 BEQ   @4_2                     ;=0 then 'x' type # opcode
0242 ACC3 AF 30 01 E1           LDA   >MPVAL                   ;Test for 16 or 8 bits for 'A' access
0243 ACC7 80 04                 BRA   @4_4                     ;Branch always
0244 ACC9
0245 ACC9              @4_2     EQU   *
0246 ACC9 AF 31 01 E1           LDA   >XPVAL                   ;Test for 16 or 8 bits for 'X/Y' access
0247 ACCD              @4_4     EQU   *
0248 ACCD D0 04                 BNE   @5                       ;Z=1 then only 8 bits in operand
0249 ACCF A9 02                 LDA   #2                       ; else C=0 then 16 bits in operand
0250 ACD1 80 08                 BRA   @6                       ;Skip normal lookup
0251 ACD3
0252 ACD3              @5       EQU   *
0253 ACD3 BF 83 AE FF           LDA   >FMT3,X                  ;index into opcode length table
0254 ACD7
0255 ACD7              * (0=1 byte, 1=2 byte, 2=3 byte, 3=4 byte)
0256 ACD7
0257 ACD7 85 3F                 STA   A2H                      ;Save for miniassembler
0258 ACD9 29 03                 AND   #$03
0259 ACDB              @6       EQU   *
0260 ACDB 85 2F                 STA   LENGTH
0261 ACDD 98                    TYA                            ;get back opcode / 2
0262 ACDE 28                    PLP                            ;get back odd even status
0263 ACDF 90 18                 BCC   @9
0264 ACE1 29 07                 AND   #$07
0265 ACE3 C9 05                 CMP   #$05
0266 ACE5 D0 03                 BNE   @7
0267 ACE7 88                    DEY                            ;nnnn1011 -> 0nnnn011
0268 ACE8 80 20                 BRA   @92
0269 ACEA
0270 ACEA 98           @7       TYA                            ;nnnxxxx1 -> 0nnn1001
0271 ACEB C9 44                 CMP   #$44                     ;BIT imm?
0272 ACED F0 06                 BEQ   @8
0273 ACEF 29 70                 AND   #$70
0274 ACF1 09 09                 ORA   #$09
0275 ACF3 80 17                 BRA   @10
0276 ACF5
0277 ACF5 A9 12        @8       LDA   #$12                     ;point to BIT
0278 ACF7 80 13                 BRA   @10
0279 ACF9
0280 ACF9 29 03        @9       AND   #03
0281 ACFB C9 03                 CMP   #$03
0282 ACFD D0 0C                 BNE   @91
0283 ACFF 98                    TYA                            ;nnnxx110 -> 0nnn0111
0284 AD00 C9 4F                 CMP   #$4F
0285 AD02 F0 06                 BEQ   @92                      ;convert to STZ
0286 AD04 29 70                 AND   #$70
0287 AD06 09 07                 ORA   #$07
0288 AD08 80 02                 BRA   @10
0289 AD0A
0290 AD0A 88           @92      DEY   
0291 AD0B 98           @91      TYA                            ;nnnnnnn0 -> 0nnnnnnn
0292 AD0C              @10      EQU   *
0293 AD0C 60                    RTS   
0294 AD0D
0295 AD0D
0296 AD0D              DISASEM2 EQU   *                        ;Disassemble 1 inst without operand
0297 AD0D A0 00                 LDY   #0
0298 AD0F 20 8B B4     @2       JSR   READPCY
0299 AD12 E6 40                 INC   A3L
0300 AD14 D0 02                 BNE   @1
0301 AD16 E6 41                 INC   A3H
0302 AD18 20 A3 A9     @1       JSR   PRBYTEFF
0303 AD1B A2 01                 LDX   #$01                     ;PRINT 1 BLANK 
0304 AD1D 20 CA A9     @3       JSR   PRBL2FF
0305 AD20 C4 2F                 CPY   LENGTH                   ;PRINT INST (1-3 BYTES) 
0306 AD22 C8                    INY                            ;IN A 12 CHR FIELD 
0307 AD23 90 EA                 BCC   @2
0308 AD25 A2 03                 LDX   #$03                     ;CHAR COUNT FOR MNEMONIC INDEX 
0309 AD27 C0 04                 CPY   #$04
0310 AD29 90 F2                 BCC   @3
0311 AD2B 60                    RTS                            ;Back to caller
0312 AD2C
0313 AD2C
0314 AD2C              DISASEM  EQU   *
0315 AD2C 20 96 AC              JSR   XINSDS1                  ;Get format, length bytes
0316 AD2F 48                    PHA                            ;SAVE MNEMONIC TABLE INDEX 
0317 AD30 20 0D AD              JSR   DISASEM2                 ;Show up to+including opcode (not operand)
0318 AD33 7A                    PLY                            ;RECOVER MNEMONIC INDEX 
0319 AD34 DA                    PHX                            ;MUST preserve X
0320 AD35 BB                    TYX                            ;Need Y index in X
0321 AD36 BF B2 AE FF           LDA   >MNEML,X
0322 AD3A 85 2C                 STA   LMNEM                    ;FETCH 3-CHAR MNEMONIC  
0323 AD3C BF 32 AF FF           LDA   >MNEMR,X                 ;  (PACKED INTO 2-BYTES) 
0324 AD40 85 2D                 STA   RMNEM
0325 AD42 20 91 AC              JSR   PR1BLNKFF                ;Output 1 space
0326 AD45 FA                    PLX                            ;MUST restore X
0327 AD46 A9 00        @1       LDA   #$00
0328 AD48 A0 05                 LDY   #$05
0329 AD4A 06 2D        @2       ASL   RMNEM                    ;SHIFT 5 BITS OF CHARACTER INTO A 
0330 AD4C 26 2C                 ROL   LMNEM
0331 AD4E 2A                    ROL   A                        ;  (CLEARS CARRY) 
0332 AD4F 88                    DEY   
0333 AD50 D0 F8                 BNE   @2
0334 AD52 69 BF                 ADC   #$BF                     ;ADD "?" OFFSET 
0335 AD54 20 D1 A9              JSR   COUTFF                   ;OUTPUT A CHAR OF MNEM 
0336 AD57 CA                    DEX   
0337 AD58 D0 EC                 BNE   @1
0338 AD5A 20 91 AC              JSR   PR1BLNKFF                ;Output 1 space
0339 AD5D A5 2E                 LDA   FORMAT
0340 AD5F AA                    TAX   
0341 AD60 BF 83 AE FF           LDA   >FMT3,X                  ;Bit6=1 = long addr mode
0342 AD64 0A                    ASL   A                        ;- if long addr mode
0343 AD65 08                    PHP                            ;save that status
0344 AD66 BF 6C AE FF           LDA   >FMT2,X                  ;get actual format
0345 AD6A 85 2E                 STA   FORMAT
0346 AD6C A2 08                 LDX   #$08                     ;CNT FOR 8 FORMAT BITS 
0347 AD6E A4 2F                 LDY   LENGTH
0348 AD70 E0 05        @111     CPX   #$05
0349 AD72 F0 27                 BEQ   @115                     ;IF X=5 THEN ADDR. 
0350 AD74 06 2E        @112     ASL   FORMAT
0351 AD76 90 18                 BCC   @113
0352 AD78 BF 99 AE FF           LDA   >CHAR1-1,X
0353 AD7C 28                    PLP   
0354 AD7D 08                    PHP   
0355 AD7E 10 04                 BPL   @116                     ;not long addr
0356 AD80 BF A9 AE FF           LDA   >CHAR3-1,X
0357 AD84              @116     EQU   *
0358 AD84 20 D1 A9              JSR   COUTFF
0359 AD87 BF A1 AE FF           LDA   >CHAR2-1,X
0360 AD8B F0 03                 BEQ   @113
0361 AD8D 20 D1 A9              JSR   COUTFF
0362 AD90 CA           @113     DEX   
0363 AD91 D0 DD                 BNE   @111
0364 AD93 28                    PLP   
0365 AD94 60                    RTS   
0366 AD95
0367 AD95 88           @114     DEY   
0368 AD96 30 DC                 BMI   @112
0369 AD98 20 A3 A9              JSR   PRBYTEFF
0370 AD9B A5 2E        @115     LDA   FORMAT
0371 AD9D C9 F8                 CMP   #$F8                     ;Handle relative addr mode
0372 AD9F 20 8B B4              JSR   READPCY                  ;Special (PRINT target, and offset)
0373 ADA2 85 3F                 STA   A2H                      ;Save hi byte of offset
0374 ADA4 90 EF                 BCC   @114                     ;
0375 ADA6 FA                    PLX                            ;get rid of [ flag
0376 ADA7 88                    DEY   
0377 ADA8 5A                    PHY                            ;MUST save as # bytes offset indicator
0378 ADA9 F0 16                 BEQ   @22                      ;one byte offset
0379 ADAB 48                    PHA                            ;save high byte
0380 ADAC 20 8B B4              JSR   READPCY                  ;get low byte
0381 ADAF 85 3E                 STA   A2L                      ;Save lo byte of offset
0382 ADB1 65 3A                 ADC   PCL                      ;note that carry was set
0383 ADB3 AA                    TAX   
0384 ADB4 68                    PLA                            ;get back high byte
0385 ADB5 65 3B                 ADC   PCH
0386 ADB7 A8                    TAY   
0387 ADB8 8A                    TXA   
0388 ADB9 18                    CLC   
0389 ADBA 69 02                 ADC   #2
0390 ADBC AA                    TAX   
0391 ADBD 90 0B                 BCC   @221
0392 ADBF 80 08                 BRA   @220
0393 ADC1
0394 ADC1 38           @22      SEC   
0395 ADC2 20 56 F9              JSR   PCADJ3
0396 ADC5 AA                    TAX                            ;PCL,PCH+OFFSET+1 TO A,Y 
0397 ADC6 E8                    INX   
0398 ADC7 D0 01                 BNE   @221                     ;+1 TO Y,X 
0399 ADC9 C8           @220     INY   
0400 ADCA              @221     EQU   *
0401 ADCA 20 9E A9              JSR   PRNTYXFF                 ;Print calculated address
0402 ADCD 20 91 AC              JSR   PR1BLNKFF                ;Output 1 space
0403 ADD0 A9 FB                 LDA   #'{'                     ;Now show offset in braces
0404 ADD2 20 D1 A9              JSR   COUTFF                   ;
0405 ADD5 A5 3F                 LDA   A2H                      ;Test for + or - move
0406 ADD7 10 1D                 BPL   @221_2                   ;+ then show '+'
0407 ADD9 A9 AD                 LDA   #'-'                     ; else show - number
0408 ADDB 20 D1 A9              JSR   COUTFF                   ;
0409 ADDE 18                    CLC                            ;Always clear C to add
0410 ADDF 68                    PLA                            ;Test 1 or 2 byte offset
0411 ADE0 48                    PHA                            ;Save again
0412 ADE1 F0 0A                 BEQ   @221_0                   ;Skip low byte if here
0413 ADE3 A5 3E                 LDA   A2L                      ;Make 2's complement
0414 ADE5 49 FF                 EOR   #$FF                     ;
0415 ADE7 69 01                 ADC   #$01                     ;
0416 ADE9 85 3E                 STA   A2L                      ;
0417 ADEB 80 01                 BRA   @221_1                   ;Skip setting carry
0418 ADED
0419 ADED              @221_0   EQU   *
0420 ADED 38                    SEC                            ;Force 1 to be added
0421 ADEE              @221_1   EQU   *
0422 ADEE A5 3F                 LDA   A2H                      ;Don't forget hi byte too
0423 ADF0 49 FF                 EOR   #$FF                     ;
0424 ADF2 69 00                 ADC   #$00                     ;Adds carry
0425 ADF4 80 07                 BRA   @221_4                   ;Exit with hi byte in 'A'
0426 ADF6
0427 ADF6              @221_2   EQU   *
0428 ADF6 A9 AB                 LDA   #'+'                     ;
0429 ADF8 20 D1 A9              JSR   COUTFF                   ;
0430 ADFB A5 3F                 LDA   A2H                      ;Pick up hi byte to show user
0431 ADFD              @221_4   EQU   *
0432 ADFD 20 A3 A9              JSR   PRBYTEFF                 ;Show to user
0433 AE00 68                    PLA                            ;Recall Y from stack
0434 AE01 F0 05                 BEQ   RELADR2                  ; and if 0 then only 1 byte offset
0435 AE03 A5 3E                 LDA   A2L                      ;Pick up lo byte of offset
0436 AE05 20 A3 A9              JSR   PRBYTEFF                 ; and show to user
0437 AE08              RELADR2  EQU   *
0438 AE08 A9 FD                 LDA   #'}'                     ;Now close and exit
0439 AE0A 4C D1 A9              JMP   COUTFF                   ;
0440 AE0D
0441 AE0D              PRAEQX   EQU   *                        ;Print A in ASCII = X in HEX
0442 AE0D DA                    PHX                            ;Save X
0443 AE0E 20 99 A9              JSR   PRHEXFF                  ;Output A in HEX
0444 AE11 A9 BD                 LDA   #'='                     ;
0445 AE13 20 D1 A9              JSR   COUTFF                   ;Output =
0446 AE16 68                    PLA                            ;Recall X
0447 AE17 48                    PHA                            ;Save for testing
0448 AE18 20 D1 A9              JSR   COUTFF                   ;Output X in ASCII
0449 AE1B 68                    PLA                            ;Test for L
0450 AE1C C9 CC                 CMP   #'L'                     ;If L do NO spaces
0451 AE1E D0 01                 BNE   @1                       ;
0452 AE20 60                    RTS                            ;Back to caller
0453 AE21
0454 AE21              @1       EQU   *
0455 AE21 4C C8 A9              JMP   PRBLNKFF                 ;Print 3 spaces now
0456 AE24
0457 AE24
0458 AE24                       EJECT 
0459 AE24              *
0460 AE24              * READ MEMORY LOCATION AT (PCL),Y
0461 AE24              *
0462 AE24              *
0463 AE24              *
0464 AE24              ; FMT1 BYTES:    XXXX XXY0 INSTRS
0465 AE24              ; IF Y=0         THEN RIGHT HALF BYTE
0466 AE24              ; IF Y=1         THEN LEFT HALF BYTE
0467 AE24              ;                  (X=INDEX)
0468 AE24              * For example PEI xx is opcode $D4 = 
0469 AE24              *    1 1 0 1  0 1 0 0
0470 AE24              *    X X X X  X X Y 0
0471 AE24              * To find the PEI in FMT1 table go to FMT1,XXXXX
0472 AE24              *    = FMT1,$35 and since Y = 0 then the right
0473 AE24              *    nybble gives the format in FMT2.  The format
0474 AE24              *    number at FMT1,$35 right nybble is $B so the
0475 AE24              *    the format looks like nn
0476 AE24              *
0477 AE24
0478 AE24                                                      ; SEG $FF
0479 AE24              FMT1     EQU   *
0480 AE24 BB BB CC 99           DC B:$BB,$BB,$CC,$99
0481 AE28 52 DB CC E9           DC B:$52,$DB,$CC,$E9
0482 AE2C A9 BB CC 99           DC B:$A9,$BB,$CC,$99
0483 AE30 52 DD CC EE           DC B:$52,$DD,$CC,$EE
0484 AE34 BC B9 CC 99           DC B:$BC,$B9,$CC,$99
0485 AE38 52 D9 CC EA           DC B:$52,$D9,$CC,$EA
0486 AE3C 3C BB CC 94           DC B:$3C,$BB,$CC,$94
0487 AE40 52 DD CC E6           DC B:$52,$DD,$CC,$E6
0488 AE44 32 BB CC 99           DC B:$32,$BB,$CC,$99
0489 AE48 52 1D CC E9           DC B:$52,$1D,$CC,$E9
0490 AE4C 88 BB CC 99           DC B:$88,$BB,$CC,$99
0491 AE50 52 1D CC FE           DC B:$52,$1D,$CC,$FE
0492 AE54 08 BB CC 99           DC B:$08,$BB,$CC,$99
0493 AE58 52 DB CC E4           DC B:$52,$DB,$CC,$E4
0494 AE5C 08 BB CC 99           DC B:$08,$BB,$CC,$99
0495 AE60 52 D9 CC E6           DC B:$52,$D9,$CC,$E6
0496 AE64              ; ZZXXXY01 INSTR'S
0497 AE64 B9 E3 40 21           DC B:$B9,$E3,$40,$21
0498 AE68 C8 D5 47 A6           DC B:$C8,$D5,$47,$A6
0499 AE6C
0500 AE6C              * FMT2 formats are defined as follows
0501 AE6C              *
0502 AE6C              * if format is taken from CHAR1
0503 AE6C              * bit 7  bit 6  bit 5  bit 4  bit 3  bit 2  bit 1  bit 0
0504 AE6C              *   #      (      $      ,      ,      ,      )      ,
0505 AE6C              *
0506 AE6C              * if format is taken from CHAR2
0507 AE6C              * bit 7  bit 6  bit 5  bit 4  bit 3  bit 2  bit 1  bit 0
0508 AE6C              *   ^      ^      ^      Y      X      S      ^      Y
0509 AE6C              * ^ = No register indicated for that format selection
0510 AE6C              *
0511 AE6C              * if format is taken from CHAR3
0512 AE6C              * bit 7  bit 6  bit 5  bit 4  bit 3  bit 2  bit 1  bit 0
0513 AE6C              *   #      [      $      ,      ,      ,      ]      ,
0514 AE6C              *
0515 AE6C
0516 AE6C              FMT2     EQU   *
0517 AE6C 80                    DC B:$80                       ; 0 # always 1 byte 
0518 AE6D 10                    DC B:$10                       ; 1 d,Y
0519 AE6E 1F                    DC B:$1F                       ; 2 r
0520 AE6F 1F                    DC B:$1F                       ; 3 rl
0521 AE70 42                    DC B:$42                       ; 4 (a)
0522 AE71 42                    DC B:$42                       ; 5 (d)
0523 AE72 4A                    DC B:$4A                       ; 6 (a,X)
0524 AE73 42                    DC B:$42                       ; 7 (a)
0525 AE74 80                    DC B:$80                       ; 8 #d (or #a if in 16 bit mode)
0526 AE75 00                    DC B:$00                       ; 9 a
0527 AE76 00                    DC B:$00                       ; A al
0528 AE77 00                    DC B:$00                       ; B d
0529 AE78 00                    DC B:$00                       ; C i
0530 AE79 08                    DC B:$08                       ; D d,X
0531 AE7A 08                    DC B:$08                       ; E a,X
0532 AE7B 10                    DC B:$10                       ; F a,Y
0533 AE7C 43                    DC B:$43                       ;10 (d),Y
0534 AE7D 4A                    DC B:$4A                       ;11 (d,X)
0535 AE7E 08                    DC B:$08                       ;12 al,X
0536 AE7F 04                    DC B:$04                       ;13 r,S
0537 AE80 47                    DC B:$47                       ;14 (r,S),Y
0538 AE81 43                    DC B:$43                       ;15 [d],Y
0539 AE82 42                    DC B:$42                       ;16 [d]
0540 AE83
0541 AE83              FMT3     EQU   *
0542 AE83 01                    DC B:$01                       ; 0 #d always 1 byte 
0543 AE84 01                    DC B:$01                       ; 1 d,Y
0544 AE85 01                    DC B:$01                       ; 2 r
0545 AE86 02                    DC B:$02                       ; 3 rl
0546 AE87 02                    DC B:$02                       ; 4 (a)
0547 AE88 01                    DC B:$01                       ; 5 (d)
0548 AE89 02                    DC B:$02                       ; 6 (a,X)
0549 AE8A 02                    DC B:$02                       ; 7 (a)
0550 AE8B 01                    DC B:$01                       ; 8 #d (or #a if 16 bit mode)
0551 AE8C 02                    DC B:$02                       ; 9 a
0552 AE8D 03                    DC B:$03                       ; A al
0553 AE8E 01                    DC B:$01                       ; B d
0554 AE8F 00                    DC B:$00                       ; C i
0555 AE90 01                    DC B:$01                       ; D d,X
0556 AE91 02                    DC B:$02                       ; E a,X
0557 AE92 02                    DC B:$02                       ; F a,Y
0558 AE93 01                    DC B:$01                       ;10 (d),Y
0559 AE94 01                    DC B:$01                       ;11 (d,X)
0560 AE95 03                    DC B:$03                       ;12 al,X
0561 AE96 01                    DC B:$01                       ;13 r,S
0562 AE97 01                    DC B:$01                       ;14 (r,S),Y
0563 AE98 41                    DC B:$41                       ;15 [d],Y
0564 AE99 41                    DC B:$41                       ;16 [d]
0565 AE9A
0566 AE9A
0567 AE9A AC           CHAR1    DC B:','
0568 AE9B A9                    DC B:')'
0569 AE9C AC                    DC B:','
0570 AE9D AC                    DC B:','
0571 AE9E AC                    DC B:','
0572 AE9F A4                    DC B:'$'
0573 AEA0 A8                    DC B:'('
0574 AEA1 A3                    DC B:'#'
0575 AEA2
0576 AEA2 D9           CHAR2    DC B:'Y'
0577 AEA3 00                    DC B:$00                       ;
0578 AEA4 D3                    DC B:'S'
0579 AEA5 D8                    DC B:'X'
0580 AEA6 D9                    DC B:'Y'
0581 AEA7 00                    DC B:$00
0582 AEA8 00                    DC B:$00
0583 AEA9 00                    DC B:$00
0584 AEAA
0585 AEAA AC           CHAR3    DC B:','
0586 AEAB DD                    DC B:']'
0587 AEAC AC                    DC B:','
0588 AEAD AC                    DC B:','
0589 AEAE AC                    DC B:','
0590 AEAF A4                    DC B:'$'
0591 AEB0 DB                    DC B:'['
0592 AEB1 A3                    DC B:'#'
0593 AEB2
0594 AEB2              MNEML    EQU   *
0595 AEB2 1C 24 AD 8A           DC B:$1C,$24,$AD,$8A
0596 AEB6 8A 15 AD 15           DC B:$8A,$15,$AD,$15
0597 AEBA 1C 84 AC A9           DC B:$1C,$84,$AC,$A9
0598 AEBE 23 53 AC 00           DC B:$23,$53,$AC,$00
0599 AEC2 5D 5D 1A 8B           DC B:$5D,$5D,$1A,$8B
0600 AEC6 8B 9C 1A 9C           DC B:$8B,$9C,$1A,$9C
0601 AECA 1B 13 1A AD           DC B:$1B,$13,$1A,$AD
0602 AECE A1 29 1A 00           DC B:$A1,$29,$1A,$00
0603 AED2 9D C1 75 8A           DC B:$9D,$C1,$75,$8A
0604 AED6 8A 6D 5B 6D           DC B:$8A,$6D,$5B,$6D
0605 AEDA 1D 34 75 A9           DC B:$1D,$34,$75,$A9
0606 AEDE 23 8A 5B 00           DC B:$23,$8A,$5B,$00
0607 AEE2 9D 89 A5 9D           DC B:$9D,$89,$A5,$9D
0608 AEE6 8B 9C 5B 9C           DC B:$8B,$9C,$5B,$9C
0609 AEEA 1D 11 A5 A9           DC B:$1D,$11,$A5,$A9
0610 AEEE A1 8B 5B 00           DC B:$A1,$8B,$5B,$00
0611 AEF2 1C 1C A5 8A           DC B:$1C,$1C,$A5,$8A
0612 AEF6 29 AE A5 A5           DC B:$29,$AE,$A5,$A5
0613 AEFA 19 A5 A5 AE           DC B:$19,$A5,$A5,$AE
0614 AEFE AE AE A5 00           DC B:$AE,$AE,$A5,$00
0615 AF02 69 69 69 8B           DC B:$69,$69,$69,$8B
0616 AF06 A8 A8 69 69           DC B:$A8,$A8,$69,$69
0617 AF0A 19 69 69 AE           DC B:$19,$69,$69,$AE
0618 AF0E 23 AD 69 00           DC B:$23,$AD,$69,$00
0619 AF12 24 99 24 C0           DC B:$24,$99,$24,$C0
0620 AF16 53 29 24 29           DC B:$53,$29,$24,$29
0621 AF1A 1B 23 89 A5           DC B:$1B,$23,$89,$A5
0622 AF1E 23 8A 5B 00           DC B:$23,$8A,$5B,$00
0623 AF22 24 A1 24 C8           DC B:$24,$A1,$24,$C8
0624 AF26 53 7C 24 53           DC B:$53,$7C,$24,$53
0625 AF2A 19 A0 89 C9           DC B:$19,$A0,$89,$C9
0626 AF2E A1 8B 5D 00           DC B:$A1,$8B,$5D,$00
0627 AF32
0628 AF32              MNEMR    EQU   *
0629 AF32 D8 22 06 4A           DC B:$D8,$22,$06,$4A
0630 AF36 62 1A 06 1A           DC B:$62,$1A,$06,$1A
0631 AF3A 5A C4 C6 28           DC B:$5A,$C4,$C6,$28
0632 AF3E 48 C8 C6 00           DC B:$48,$C8,$C6,$00
0633 AF42 26 1A AA 4A           DC B:$26,$1A,$AA,$4A
0634 AF46 62 1A AA 1A           DC B:$62,$1A,$AA,$1A
0635 AF4A 94 CA AA 08           DC B:$94,$CA,$AA,$08
0636 AF4E 88 88 AA 00           DC B:$88,$88,$AA,$00
0637 AF52 54 5C E2 58           DC B:$54,$5C,$E2,$58
0638 AF56 44 26 A2 26           DC B:$44,$26,$A2,$26
0639 AF5A C8 26 DE 0A           DC B:$C8,$26,$DE,$0A
0640 AF5E 54 74 A2 00           DC B:$54,$74,$A2,$00
0641 AF62 68 A6 76 5A           DC B:$68,$A6,$76,$5A
0642 AF66 44 26 A2 26           DC B:$44,$26,$A2,$26
0643 AF6A E8 48 76 48           DC B:$E8,$48,$76,$48
0644 AF6E 94 74 A2 00           DC B:$94,$74,$A2,$00
0645 AF72 C4 DA 74 46           DC B:$C4,$DA,$74,$46
0646 AF76 B4 44 74 72           DC B:$B4,$44,$74,$72
0647 AF7A 08 44 74 74           DC B:$08,$44,$74,$74
0648 AF7E 84 68 76 00           DC B:$84,$68,$76,$00
0649 AF82 74 72 74 46           DC B:$74,$72,$74,$46
0650 AF86 B4 B2 74 72           DC B:$B4,$B2,$74,$72
0651 AF8A 28 44 74 B2           DC B:$28,$44,$74,$B2
0652 AF8E 6E 32 74 00           DC B:$6E,$32,$74,$00
0653 AF92 74 A2 74 94           DC B:$74,$A2,$74,$94
0654 AF96 F4 B2 74 88           DC B:$F4,$B2,$74,$88
0655 AF9A CC A2 94 62           DC B:$CC,$A2,$94,$62
0656 AF9E 4A 72 9A 00           DC B:$4A,$72,$9A,$00
0657 AFA2 72 A2 72 C4           DC B:$72,$A2,$72,$C4
0658 AFA6 F2 22 72 C8           DC B:$F2,$22,$72,$C8
0659 AFAA A4 C8 84 0C           DC B:$A4,$C8,$84,$0C
0660 AFAE 8A 72 26 00           DC B:$8A,$72,$26,$00
0661 AFB2
0662 AFB2                                                      ; SEG $00
0663 AFB2                       EJECT 
0664 AFB2                       TITLE '65SC816 Opcodes/Modes/# of bytes'
0665 AFB2              ***************************************************
0666 AFB2              *                                                 *
0667 AFB2              *      65SC816 Opcodes/Modes/Number of Bytes      *
0668 AFB2              *                                                 *
0669 AFB2              ***************************************************
0670 AFB2
0671 AFB2              *   Name Mode      Bytes     Opcode #
0672 AFB2              *   ---- --------- -------  ------------------------------
0673 AFB2              *        #                   immediate
0674 AFB2              *        (a)                 absolute indirect
0675 AFB2              *        (a,X)               absolute indexed indirect
0676 AFB2              *        (d)                 direct indirect
0677 AFB2              *        (d),Y               direct indirect indexed
0678 AFB2              *        (d,X)               direct indexed indirect
0679 AFB2              *        (r,S),Y             stack relative indirect indexed
0680 AFB2              *        a                   absolute
0681 AFB2              *        a,X                 absolute indexed (with X)
0682 AFB2              *        a,Y                 absolute indexed (with Y)
0683 AFB2              *        Acc                 Accumulator
0684 AFB2              *        al                  absolute long
0685 AFB2              *        al,X                absolute indexed long
0686 AFB2              *        d                   direct
0687 AFB2              *        d,X                 direct indexed (with X)
0688 AFB2              *        d,Y                 direct indexed (with Y)
0689 AFB2              *        i                   implied
0690 AFB2              *        r                   program counter relative
0691 AFB2              *        r,S                 stack relative
0692 AFB2              *        rl                  program counter relative long
0693 AFB2              *        s                   stack
0694 AFB2              *        XYA                 block move
0695 AFB2              *        [d]                 direct indirect long
0696 AFB2              *        [d],Y               direct indirect indexed long
0697 AFB2
0698 AFB2              *   ---- --------- --------- -----------------------------
0699 AFB2              *   BRK  i           2       00
0700 AFB2              *   ORA  (d,X)       2       01
0701 AFB2              *   COP  i           2       02
0702 AFB2              *   ORA  r,S         2       03
0703 AFB2              *   TSB  d           2       04
0704 AFB2              *   ORA  d           2       05
0705 AFB2              *   ASL  d           2       06
0706 AFB2              *   ORA  [d]         2       07
0707 AFB2              *   PHP  s           1       08
0708 AFB2              *   ORA  #           2 (3)   09
0709 AFB2              *   ASL  Acc         1       0A
0710 AFB2              *   PHD  s           1       0B
0711 AFB2              *   TSB  a           3       0C
0712 AFB2              *   ORA  a           3       0D
0713 AFB2              *   ASL  a           3       0E
0714 AFB2              *   ORA  al          4       0F
0715 AFB2              *   BPL  r           2       10
0716 AFB2              *   ORA  (d),Y       2       11
0717 AFB2              *   ORA  (d)         2       12
0718 AFB2              *   ORA  (r,S),Y     2       13
0719 AFB2              *   TRB  d           2       14
0720 AFB2              *   ORA  d,X         2       15
0721 AFB2              *   ASL  d,X         2       16
0722 AFB2              *   ORA  [d],Y       2       17
0723 AFB2              *   CLC  i           1       18
0724 AFB2              *   ORA  a,Y         3       19
0725 AFB2              *   INC  Acc         1       1A
0726 AFB2              *   TCS  i           1       1B
0727 AFB2              *   TRB  a           3       1C
0728 AFB2              *   ORA  a,X         3       1D
0729 AFB2              *   ASL  a,X         3       1E
0730 AFB2              *   ORA  al,X        4       1F
0731 AFB2              *   JSR  a           3       20
0732 AFB2              *   AND  (d,X)       2       21
0733 AFB2              *   JSL  al          4       22
0734 AFB2              *   AND  r,S         2       23
0735 AFB2              *   BIT  d           2       24
0736 AFB2              *   AND  d           2       25
0737 AFB2              *   ROL  d           2       26
0738 AFB2              *   AND  [d]         2       27
0739 AFB2              *   PLP  s           1       28
0740 AFB2              *   AND  #           2 (3)   29
0741 AFB2              *   ROL  Acc         1       2A
0742 AFB2              *   PLD  s           1       2B
0743 AFB2              *   BIT  a           3       2C
0744 AFB2              *   AND  a           3       2D
0745 AFB2              *   ROL  a           3       2E
0746 AFB2              *   AND  al          4       2F
0747 AFB2              *   BMI  r           2       30
0748 AFB2              *   AND  (d),Y       2       31
0749 AFB2              *   AND  (d)         2       32
0750 AFB2              *   AND  (r,S),Y     2       33
0751 AFB2              *   BIT  d,X         2       34
0752 AFB2              *   AND  d,X         2       35
0753 AFB2              *   ROL  d,X         2       36
0754 AFB2              *   AND  [d],Y       2       37
0755 AFB2              *   SEC  i           1       38
0756 AFB2              *   AND  a,Y         3       39
0757 AFB2              *   DEC  Acc         1       3A
0758 AFB2              *   TSC  i           1       3B
0759 AFB2              *   BIT  a,X         3       3C
0760 AFB2              *   AND  a,X         3       3D
0761 AFB2              *   ROL  a,X         3       3E
0762 AFB2              *   AND  al,X        4       3F
0763 AFB2              *   RTI  s           1       40
0764 AFB2              *   EOR  (d,X)       2       41
0765 AFB2              *   WDM  i           2       42
0766 AFB2              *   EOR  r,S         2       43
0767 AFB2              *   MVP  XYA         3       44
0768 AFB2              *   EOR  d           2       45
0769 AFB2              *   LSR  d           2       46
0770 AFB2              *   EOR  [d]         2       47
0771 AFB2              *   PHA  s           1       48
0772 AFB2              *   EOR  #           2 (3)   49
0773 AFB2              *   LSR  Acc         1       4A
0774 AFB2              *   PHK  s           1       4B
0775 AFB2              *   JMP  a           3       4C
0776 AFB2              *   EOR  a           3       4D
0777 AFB2              *   LSR  a           3       4E
0778 AFB2              *   EOR  al          4       4F
0779 AFB2              *   BVC  r           2       50
0780 AFB2              *   EOR  (d),Y       2       51
0781 AFB2              *   EOR  (d)         2       52
0782 AFB2              *   EOR  (r,S),Y     2       53
0783 AFB2              *   MVN  XYA         3       54
0784 AFB2              *   EOR  d,X         2       55
0785 AFB2              *   LSR  d,X         2       56
0786 AFB2              *   EOR  [d],Y       2       57
0787 AFB2              *   CLI  i           1       58
0788 AFB2              *   EOR  a,Y         3       59
0789 AFB2              *   PHY  s           1       5A
0790 AFB2              *   TCD  i           1       5B
0791 AFB2              *   JMP  al          4       5C
0792 AFB2              *   EOR  a,X         3       5D
0793 AFB2              *   LSR  a,X         3       5E
0794 AFB2              *   EOR  al,X        4       5F
0795 AFB2              *   RTS  s           1       60
0796 AFB2              *   ADC  (d,X)       2       61
0797 AFB2              *   PER  s           3       62
0798 AFB2              *   ADC  r,S         2       63
0799 AFB2              *   STZ  d           2       64
0800 AFB2              *   ADC  d           2       65
0801 AFB2              *   ROR  d           2       66
0802 AFB2              *   ADC  [d]         2       67
0803 AFB2              *   PLA  s           1       68
0804 AFB2              *   ADC  #           2 (3)   69
0805 AFB2              *   ROR  Acc         1       6A
0806 AFB2              *   RTL  s           1       6B
0807 AFB2              *   JMP  (a)         3       6C
0808 AFB2              *   ADC  a           3       6D
0809 AFB2              *   ROR  a           3       6E
0810 AFB2              *   ADC  al          4       6F
0811 AFB2              *   BVS  r           2       70
0812 AFB2              *   ADC  (d),Y       2       71
0813 AFB2              *   ADC  (d)         2       72
0814 AFB2              *   ADC  (r,S),Y     2       73
0815 AFB2              *   STZ  d,X         2       74
0816 AFB2              *   ADC  d,X         2       75
0817 AFB2              *   ROR  d,X         2       76
0818 AFB2              *   ADC  [d],Y       2       77
0819 AFB2              *   SEI  i           1       78
0820 AFB2              *   ADC  a,Y         3       79
0821 AFB2              *   PLY  s           1       7A
0822 AFB2              *   TDC  i           1       7B
0823 AFB2              *   JMP  (a,X)       3       7C
0824 AFB2              *   ADC  a,X         3       7D
0825 AFB2              *   ROR  a,X         3       7E
0826 AFB2              *   ADC  al,X        4       7F
0827 AFB2              *   BRA  r           2       80
0828 AFB2              *   STA  (d,X)       2       81
0829 AFB2              *   BRL  rl          3       82
0830 AFB2              *   STA  r,S         2       83
0831 AFB2              *   STY  d           2       84
0832 AFB2              *   STA  d           2       85
0833 AFB2              *   STX  d           2       86
0834 AFB2              *   STA  [d]         2       87
0835 AFB2              *   DEY  i           1       88
0836 AFB2              *   BIT  #           2 (3)   89
0837 AFB2              *   TXA  i           1       8A
0838 AFB2              *   PHB  s           1       8B
0839 AFB2              *   STY  a           3       8C
0840 AFB2              *   STA  a           3       8D
0841 AFB2              *   STX  a           3       8E
0842 AFB2              *   STA  al          4       8F
0843 AFB2              *   BCC  r           2       90
0844 AFB2              *   STA  (d),Y       2       91
0845 AFB2              *   STA  (d)         2       92
0846 AFB2              *   STA  (r,S),Y     2       93
0847 AFB2              *   STY  d,X         2       94
0848 AFB2              *   STA  d,X         2       95
0849 AFB2              *   STX  d,Y         2       96
0850 AFB2              *   STA  [d],Y       2       97
0851 AFB2              *   TYA  i           1       98
0852 AFB2              *   STA  a,Y         3       99
0853 AFB2              *   TXS  i           1       9A
0854 AFB2              *   TXY  i           1       9B
0855 AFB2              *   STZ  a           3       9C
0856 AFB2              *   STA  a,X         3       9D
0857 AFB2              *   STZ  a,X         3       9E
0858 AFB2              *   STA  al,X        4       9F
0859 AFB2              *   LDY  #           2 (3)   A0
0860 AFB2              *   LDA  (d,X)       2       A1
0861 AFB2              *   LDX  #           2 (3)   A2
0862 AFB2              *   LDA  r,S         2       A3
0863 AFB2              *   LDY  d           2       A4
0864 AFB2              *   LDA  d           2       A5
0865 AFB2              *   LDX  d           2       A6
0866 AFB2              *   LDA  [d]         2       A7
0867 AFB2              *   TAY  i           1       A8
0868 AFB2              *   LDA  #           2 (3)   A9
0869 AFB2              *   TAX  i           1       AA
0870 AFB2              *   PLB  s           1       AB
0871 AFB2              *   LDY  a           3       AC
0872 AFB2              *   LDA  a           3       AD
0873 AFB2              *   LDX  a           3       AE
0874 AFB2              *   LDA  al          4       AF
0875 AFB2              *   BCS  r           2       B0
0876 AFB2              *   LDA  (d),Y       2       B1
0877 AFB2              *   LDA  (d)         2       B2
0878 AFB2              *   LDA  (r,S),Y     2       B3
0879 AFB2              *   LDY  d,X         2       B4
0880 AFB2              *   LDA  d,X         2       B5
0881 AFB2              *   LDX  d,Y         2       B6
0882 AFB2              *   LDA  [d],Y       2       B7
0883 AFB2              *   CLV  i           1       B8
0884 AFB2              *   LDA  a,Y         3       B9
0885 AFB2              *   TSX  i           1       BA
0886 AFB2              *   TYX  i           1       BB
0887 AFB2              *   LDY  a,X         3       BC
0888 AFB2              *   LDA  a,X         3       BD
0889 AFB2              *   LDX  a,Y         3       BE
0890 AFB2              *   LDA  al,X        4       BF
0891 AFB2              *   CPY  #           2 (3)   C0
0892 AFB2              *   CMP  (d,X)       2       C1
0893 AFB2              *   REP  #           2       C2
0894 AFB2              *   CMP  r,S         2       C3
0895 AFB2              *   CPY  d           2       C4
0896 AFB2              *   CMP  d           2       C5
0897 AFB2              *   DEC  d           2       C6
0898 AFB2              *   CMP  [d]         2       C7
0899 AFB2              *   INY  i           1       C8
0900 AFB2              *   CMP  #           2 (3)   C9
0901 AFB2              *   DEX  i           1       CA
0902 AFB2              *   WAI  i           1       CB
0903 AFB2              *   CPY  a           3       CC
0904 AFB2              *   CMP  a           3       CD
0905 AFB2              *   DEC  a           3       CE
0906 AFB2              *   CMP  al          4       CF
0907 AFB2              *   BNE  r           2       D0
0908 AFB2              *   CMP  (d),Y       2       D1
0909 AFB2              *   CMP  (d)         2       D2
0910 AFB2              *   CMP  (r,S),Y     2       D3
0911 AFB2              *   PEI  s           2       D4
0912 AFB2              *   CMP  d,X         2       D5
0913 AFB2              *   DEC  d,X         2       D6
0914 AFB2              *   CMP  [d],Y       2       D7
0915 AFB2              *   CLD  i           1       D8
0916 AFB2              *   CMP  a,Y         3       D9
0917 AFB2              *   PHX  s           1       DA
0918 AFB2              *   STP  i           1       DB
0919 AFB2              *   JML  (a)         3       DC
0920 AFB2              *   CMP  a,X         3       DD
0921 AFB2              *   DEC  a,X         3       DE
0922 AFB2              *   CMP  al,X        4       DF
0923 AFB2              *   CPX  #           2 (3)   E0
0924 AFB2              *   SBC  (d,X)       2       E1
0925 AFB2              *   SEP  #           2       E2
0926 AFB2              *   SBC  r,S         2       E3
0927 AFB2              *   CPX  d           2       E4
0928 AFB2              *   SBC  d           2       E5
0929 AFB2              *   INC  d           2       E6
0930 AFB2              *   SBC  [d]         2       E7
0931 AFB2              *   INX  i           1       E8
0932 AFB2              *   SBC  #           2 (3)   E9
0933 AFB2              *   NOP  i           1       EA
0934 AFB2              *   XBA  i           1       EB
0935 AFB2              *   CPX  a           3       EC
0936 AFB2              *   SBC  a           3       ED
0937 AFB2              *   INC  a           3       EE
0938 AFB2              *   SBC  al          4       EF
0939 AFB2              *   BEQ  r           2       F0
0940 AFB2              *   SBC  (d),Y       2       F1
0941 AFB2              *   SBC  (d)         2       F2
0942 AFB2              *   SBC  (r,S),Y     2       F3
0943 AFB2              *   PEA  s           3       F4
0944 AFB2              *   SBC  d,X         2       F5
0945 AFB2              *   INC  d,X         2       F6
0946 AFB2              *   SBC  [d],Y       2       F7
0947 AFB2              *   SED  i           1       F8
0948 AFB2              *   SBC  a,Y         3       F9
0949 AFB2              *   PLX  s           1       FA
0950 AFB2              *   XCE  i           1       FB
0951 AFB2              *   JSR  (a,X)       3       FC
0952 AFB2              *   SBC  a,X         3       FD
0953 AFB2              *   INC  a,X         3       FE
0954 AFB2              *   SBC  al,X        4       FF
0955 AFB2
0956 AFB2
0957 AFB2                       TITLE '65SC816 MiniAssembler'
0958 AFB2
0959 AFB2              ******************************************************
0960 AFB2              *                                                    *
0961 AFB2              *            MiniAssembler for the 65SC816           *
0962 AFB2              *                    by                              *
0963 AFB2              *               Fern Bachman     1985-1987           *
0964 AFB2              *               Joe Bo           1987-1989           *
0965 AFB2              *                                                    *
0966 AFB2              *       Developed from the 65C02 MiniAssembler       *
0967 AFB2              *                         by                         *
0968 AFB2              *                       Ed Lai                       *
0969 AFB2              *                                                    *
0970 AFB2              *       Copyright Apple Computer, Inc. 1985-1989     *
0971 AFB2              *                All Rights Reserved.                *
0972 AFB2              *                                                    *
0973 AFB2              ******************************************************
0974 AFB2
0975 AFB2
0976 AFB2              * Calculate offset byte for relative addresses
0977 AFB2
0978 AFB2              REL      EQU   *                        ;calc relative address
0979 AFB2 AF 42 01 E1           LDA   >DIGITCNT                ;Length must be 2 or less or error
0980 AFB6 C9 03                 CMP   #3                       ;
0981 AFB8 B0 20                 BCS   GOERR                    ;Error exit
0982 AFBA A5 3D                 LDA   A1H                      ;Test for BRL/PER or regular 1 byte branch
0983 AFBC C9 82                 CMP   #$82                     ;Is it a BRL?
0984 AFBE F0 1D                 BEQ   BRANCHLONG               ;
0985 AFC0 C9 62                 CMP   #$62                     ;Is it a PER?
0986 AFC2 F0 19                 BEQ   BRANCHLONG               ;A 'PER' is processed as a BRL instruction
0987 AFC4 A4 41                 LDY   A3H                      ;
0988 AFC6 A6 40                 LDX   A3L                      ;
0989 AFC8 D0 01                 BNE   @1
0990 AFCA 88                    DEY                            ;point to offset
0991 AFCB CA           @1       DEX                            ;displacement - 1
0992 AFCC 8A                    TXA   
0993 AFCD 18                    CLC   
0994 AFCE E5 3A                 SBC   PCL                      ;subtract current PCL
0995 AFD0 85 40                 STA   A3L                      ;and save as displacement
0996 AFD2 10 01                 BPL   @2                       ;check page
0997 AFD4 C8                    INY   
0998 AFD5 98           @2       TYA                            ;get page
0999 AFD6 E5 3B                 SBC   PCH                      ;check page
1000 AFD8 F0 10                 BEQ   MOVINST
1001 AFDA 4C 55 B0     GOERR    JMP   MINIERR                  ;display error
1002 AFDD
1003 AFDD              BRANCHLONG EQU   *
1004 AFDD C2 30                 REP   #$30                     ;Go to 16 bit land to do some things
1005 AFDF A5 40                 LDA   A3L                      ;To address
1006 AFE1 3A                    DEC   A                        ;Offset by 2
1007 AFE2 3A                    DEC   A                        ;
1008 AFE3 18                    CLC                            ;Causes correct subtraction
1009 AFE4 E5 3A                 SBC   PCL                      ;From address
1010 AFE6 85 40                 STA   A3L                      ;Save offset
1011 AFE8 E2 30                 SEP   #$30                     ;Back to 8 bit land
1012 AFEA
1013 AFEA
1014 AFEA              MOVINST  EQU   *                        ;Move byte(s) to memory
1015 AFEA 20 99 B2              JSR   MOVINST1                 ;
1016 AFED
1017 AFED              * Display instruction
1018 AFED
1019 AFED 20 C8 A9              JSR   PRBLNKFF                 ;print blanks to make ProDOS work
1020 AFF0 20 75 A9              JSR   UPFF                     ;move up 2 lines
1021 AFF3 20 75 A9              JSR   UPFF
1022 AFF6 20 2C AD              JSR   DISASEM                  ;disassemble the instruction
1023 AFF9 20 7B AC              JSR   FIXPC                    ;Calculate new PC and update PCL/PCH
1024 AFFC 80 66                 BRA   GETINST                  ;and go get next instruction
1025 AFFE
1026 AFFE              * Compare disassembly of all known opcodes with
1027 AFFE              * the one typed in until a match is found
1028 AFFE
1029 AFFE A5 3D        GETOP    LDA   A1H                      ;get opcode
1030 B000 20 9C AC              JSR   INSDS3                   ;determine mnemonic index
1031 B003 DA                    PHX                            ;Save Offset into length table
1032 B004 48                    PHA                            ;
1033 B005 A6 2E                 LDX   FORMAT                   ;Convert offset into format
1034 B007 BF 6C AE FF           LDA   >FMT2,X                  ; to a format the miniassembler 
1035 B00B 85 2E                 STA   FORMAT                   ;  understands.
1036 B00D 68                    PLA                            ;
1037 B00E AA                    TAX                            ;X = index
1038 B00F BF 32 AF FF           LDA   >MNEMR,X                 ;get right half of index
1039 B013 C5 42                 CMP   A4L                      ;does it match entry?
1040 B015 D0 35                 BNE   NXTOP                    ;=>try next opcode
1041 B017 BF B2 AE FF           LDA   >MNEML,X                 ;get left half of index
1042 B01B C5 43                 CMP   A4H                      ;does it match entry?
1043 B01D D0 2D                 BNE   NXTOP                    ;=>no, try next opcode
1044 B01F A4 2E                 LDY   FORMAT                   ;get addr. mode format for that opcode
1045 B021 C0 1F                 CPY   #$1F                     ;Is it a relative address?
1046 B023 D0 0A                 BNE   TESTLEN                  ;<> a branch type inst then test others
1047 B025 FA                    PLX                            ;Clean up stack
1048 B026 4C B2 AF              JMP   REL                      ;
1049 B029
1050 B029              DOINST2  EQU   *
1051 B029 4C 35 B1              JMP   DOLIN                    ;Go attempt disassembly
1052 B02C              DOINST4  EQU   *
1053 B02C 4C 1B B1              JMP   GETI1                    ;
1054 B02F
1055 B02F              TESTLEN  EQU   *
1056 B02F FA                    PLX                            ;Did user enter 8/16 bit # instruction?
1057 B030 A5 2C                 LDA   LMNEM                    ;found opcode, check address mode
1058 B032 C5 2E                 CMP   FORMAT                   ;does mode match?
1059 B034 D0 17                 BNE   NXTOP2                   ;
1060 B036 AF 42 01 E1           LDA   >DIGITCNT                ;Make sure length is same too
1061 B03A C5 3F                 CMP   A2H                      ;
1062 B03C              @1       EQU   *
1063 B03C F0 AC                 BEQ   MOVINST                  ;=>yes, move instruction to memory
1064 B03E E0 08                 CPX   #8                       ;
1065 B040 D0 0B                 BNE   NXTOP2                   ;
1066 B042 C9 01                 CMP   #1                       ;1 or 2 bytes is OK
1067 B044 F0 F6                 BEQ   @1                       ;
1068 B046 C9 02                 CMP   #2                       ;
1069 B048 F0 F2                 BEQ   @1                       ;
1070 B04A D0 01                 BNE   NXTOP2                   ;Try next opcode
1071 B04C              NXTOP    EQU   *
1072 B04C FA                    PLX                            ;Clean up stack
1073 B04D              NXTOP2   EQU   *
1074 B04D C6 3D                 DEC   A1H                      ;else try next opcode
1075 B04F D0 AD                 BNE   GETOP                    ;=>go try it
1076 B051 C6 35                 DEC   YSAV1
1077 B053 F0 A9                 BEQ   GETOP                    ;=>go try next format
1078 B055
1079 B055              * Point to the error with a caret, beep, and fall 
1080 B055              * into the mini-assembler.
1081 B055
1082 B055 A4 34        MINIERR  LDY   YSAV                     ;get position
1083 B057 98           MINIERR2 TYA   
1084 B058 AA                    TAX   
1085 B059 20 CA A9              JSR   PRBL2FF                  ;tab to the error
1086 B05C A9 DE                 LDA   #$DE                     ;to print a caret "^"
1087 B05E 20 D1 A9              JSR   COUTFF                   ;print it
1088 B061 20 51 9A              JSR   NEWBELL1                 ;Ring the dingy
1089 B064 20 94 A9     GETINST  JSR   GETLNZFF                 ;and go get next instruction
1090 B067
1091 B067              * Read a line of input.  If prefaced with " ", decode
1092 B067              * mnemonic. If "$" do monitor command.  Otherwise parse
1093 B067              * hex address before decoding mnemonic.
1094 B067
1095 B067              DOINST   EQU   *
1096 B067 A9 00                 LDA   #$00                     ;clear mode
1097 B069 85 31                 STA   MONMODE                  ;
1098 B06B A8                    TAY                            ;0 out Y
1099 B06C AD 00 02              LDA   IN                       ;get first char in line
1100 B06F C9 A0                 CMP   #$A0                     ;if blank, 
1101 B071 F0 B6                 BEQ   DOINST2                  ;Go attempt disassembly
1102 B073 C9 BA                 CMP   #':'                     ;Test for data entry mode
1103 B075 F0 37                 BEQ   HEXENTRY                 ;
1104 B077 C9 A2                 CMP   #'"'                     ;Test for literal ASCII input
1105 B079 F0 61                 BEQ   ASCLITERAL               ;ASCII string literal entry if ' entered
1106 B07B C9 8D                 CMP   #$8D                     ;is it return?
1107 B07D D0 AD                 BNE   DOINST4                  ;=>no, continue
1108 B07F C2 30                 REP   #$30                     ;Off to 16 bit land to save a byte
1109 B081 68                    PLA                            ;Recall MPVAL/XPVAL
1110 B082 8F 30 01 E1           STA   >MPVAL                   ;Restore said values
1111 B086 E2 30                 SEP   #$30                     ;Back to normal bank FF monitor mode
1112 B088 4C 4D A3              JMP   MONZ2RTN                 ;
1113 B08B
1114 B08B
1115 B08B              MINIFF   EQU   *
1116 B08B C2 30                 REP   #$30                     ;Off to 16 bit land to save a byte
1117 B08D AF 30 01 E1           LDA   >MPVAL                   ;Restore said values
1118 B091 48                    PHA                            ;Save MPVAL/XPVAL
1119 B092 E2 30                 SEP   #$30                     ;Back to normal bank FF monitor mode
1120 B094 A9 A1                 LDA   #$A1                     ;get mini-prompt "!"
1121 B096 85 33                 STA   PROMPT
1122 B098 AD 01 02              LDA   IN+1                     ;Test for CR -- If none assume address
1123 B09B C9 8D                 CMP   #$8D                     ;
1124 B09D F0 C5                 BEQ   GETINST                  ;
1125 B09F A0 00                 LDY   #$00                     ;Move $20 bytes back to start of line
1126 B0A1              @1       EQU   *
1127 B0A1 B9 01 02              LDA   IN+1,Y                   ;From
1128 B0A4 99 00 02              STA   IN,Y                     ;To
1129 B0A7 C8                    INY                            ;Next
1130 B0A8 C0 20                 CPY   #$20                     ;Test for done
1131 B0AA D0 F5                 BNE   @1                       ;
1132 B0AC 80 B9                 BRA   DOINST                   ;Do instruction
1133 B0AE
1134 B0AE
1135 B0AE              HEXENTRY EQU   *                        ;User entering data directly
1136 B0AE C8                    INY                            ;Start with 2nd character in input buffer
1137 B0AF 84 34                 STY   YSAV                     ;Save 'Y' index
1138 B0B1              @1       EQU   *                        ;
1139 B0B1 A4 34                 LDY   YSAV                     ;Recall index in line
1140 B0B3 20 4B B2              JSR   GETNUMFF                 ;Get some data
1141 B0B6 84 34                 STY   YSAV                     ;Save entry into line
1142 B0B8 20 D2 B2              JSR   HEXENTRY3                ;Move hex data to memory
1143 B0BB D0 F4                 BNE   @1                       ;Loop for more entry
1144 B0BD              TOGETINST EQU   *
1145 B0BD 80 A5                 BRA   GETINST                  ;= then last entry
1146 B0BF
1147 B0BF
1148 B0BF              LITERALASC EQU   *
1149 B0BF A9 BA                 LDA   #$BA                     ;Stay in store mode
1150 B0C1 85 31                 STA   MONMODE                  ;
1151 B0C3 A4 34                 LDY   YSAV                     ;Input buffer location
1152 B0C5 A5 40                 LDA   A3L                      ;Move address to PCL/PCH
1153 B0C7 85 3A                 STA   PCL                      ;
1154 B0C9 A5 41                 LDA   A3H                      ;
1155 B0CB 85 3B                 STA   PCH                      ;
1156 B0CD 88                    DEY                            ;Offset since YSAV is one to many
1157 B0CE 20 E1 B0              JSR   ASCLITERAL1              ;Store data
1158 B0D1 C9 8D                 CMP   #$8D                     ;Carriage return then to MONZRTN else
1159 B0D3 F0 04                 BEQ   @1                       ; point to nxt item in buffer+continue.
1160 B0D5 C8                    INY                            ;'Y' always points to next item in buffer
1161 B0D6 84 34                 STY   YSAV                     ; and is saved in YSAV.
1162 B0D8 60                    RTS                            ;Exit back to regular monitor routines
1163 B0D9
1164 B0D9              @1       EQU   *
1165 B0D9 4C 4D A3              JMP   MONZ2RTN                 ;End rest of line and reenter monitor
1166 B0DC
1167 B0DC              ASCLITERAL EQU   *                      ;User entering ASCII string data directly
1168 B0DC 20 E1 B0              JSR   ASCLITERAL1              ;
1169 B0DF 80 DC                 BRA   TOGETINST                ;Back to miniassembler stuff
1170 B0E1
1171 B0E1              ASCLITERAL1 EQU   *
1172 B0E1 C8                    INY                            ;Test next char for $8D to terminate entry
1173 B0E2 B9 00 02              LDA   IN,Y                     ;Get next character
1174 B0E5 C9 8D                 CMP   #$8D                     ;Carriage return then no more entry
1175 B0E7 F0 31                 BEQ   @1                       ;Go for next line
1176 B0E9 C9 A2                 CMP   #'"'                     ;'"' is line terminator
1177 B0EB F0 2D                 BEQ   @1                       ;Exit if terminator found
1178 B0ED 5A                    PHY                            ;Save input buffer index
1179 B0EE 2F 34 01 E1           AND   >ASCFILTER               ;Filter the ASCII entered
1180 B0F2 48                    PHA                            ;Save 'A' value
1181 B0F3 A0 00                 LDY   #$00                     ;Required for PCYTOA3
1182 B0F5 20 E3 AA              JSR   PCYTOA3                  ;Find location
1183 B0F8 68                    PLA                            ;Recall value to print
1184 B0F9 20 EC B7              JSR   STORBYTE                 ;Store byte in memory
1185 B0FC 64 2F                 STZ   LENGTH                   ;Fake out PCADJ
1186 B0FE A5 3B                 LDA   PCH                      ;CHK if PCH already at $ff
1187 B100 49 FF                 EOR   #$FF
1188 B102 D0 10                 BNE   @2                       ;Bra if not
1189 B104 A5 3A                 LDA   PCL                      ;Else need to chk for crossing bank
1190 B106 48                    PHA                            ;Save as old PCL before PCADJ
1191 B107 20 7B AC              JSR   FIXPC                    ;Update for new PC
1192 B10A 68                    PLA                            ;Get back old PCL
1193 B10B C5 3A                 CMP   PCL                      ;Compare with new PCL
1194 B10D 90 08                 BCC   @3                       ;Bra if not yet crossing bank
1195 B10F 20 6B B3              JSR   INCBANKS                 ;Else need to adjust BANKS
1196 B112 80 03                 BRA   @3                       ;Continue but in new bank
1197 B114              @2       EQU   *
1198 B114 20 7B AC              JSR   FIXPC                    ;Calls PCADJ
1199 B117              @3       EQU   *
1200 B117 7A                    PLY                            ;Recall 'Y' index
1201 B118 80 C7                 BRA   ASCLITERAL1              ;Loop til carriage return found
1202 B11A
1203 B11A              @1       EQU   *
1204 B11A 60                    RTS                            ;Back to caller
1205 B11B
1206 B11B
1207 B11B 20 72 B2     GETI1    JSR   XGETNUMFF                ;parse hexadecimal input
1208 B11E C9 93                 CMP   #$93                     ;look for "ADDR:" 
1209 B120 D0 21        GOMINIERR2 BNE   NXTCHR0                ;no ":", display error 
1210 B122 20 62 FE              JSR   A1PC                     ;Move address to PCL/PCH
1211 B125 F0 1C                 BEQ   NXTCHR0                  ;no "ADDR", display error
1212 B127 B9 00 02              LDA   IN,Y                     ;Test for literal input modes
1213 B12A C9 A2                 CMP   #'"'                     ;If '"' here then literal ASCII entry
1214 B12C F0 AE                 BEQ   ASCLITERAL               ;
1215 B12E C9 BA                 CMP   #':'                     ;If : here then literal HEX entry
1216 B130 D0 03                 BNE   DOLIN
1217 B132 4C AE B0              JMP   HEXENTRY                 ;Jump for hex entry
1218 B135              DOLIN    EQU   *
1219 B135 A9 03                 LDA   #$03                     ;get starting opcode
1220 B137 85 3D                 STA   A1H                      ;and save
1221 B139 20 13 FF     NXTCH    JSR   NNBL                     ;get next non-blank
1222 B13C 0A                    ASL   A                        ;validate entry
1223 B13D E9 BE                 SBC   #$BE
1224 B13F C9 C2                 CMP   #$C2
1225 B141 B0 03                 BCS   NXTCH2                   ;Continue normally if 'c'=1
1226 B143 4C 57 B0     NXTCHR0  JMP   MINIERR2                 ;=>flag bad mnemonic
1227 B146
1228 B146              * Form mnemonic for later comparison
1229 B146
1230 B146              NXTCH2   EQU   *
1231 B146 0A                    ASL   A
1232 B147 0A                    ASL   A
1233 B148 A2 04                 LDX   #$04
1234 B14A 0A           @111     ASL   A
1235 B14B 26 42                 ROL   A4L
1236 B14D 26 43                 ROL   A4H
1237 B14F CA                    DEX   
1238 B150 10 F8                 BPL   @111
1239 B152 C6 3D                 DEC   A1H                      ;decrement mnemonic count
1240 B154 F0 F4                 BEQ   @111
1241 B156 10 E1                 BPL   NXTCH
1242 B158 A2 07                 LDX   #$7                      ;index into address mode tables
1243 B15A 64 3E                 STZ   A2L                      ;0= not long address
1244 B15C              @1       EQU   *
1245 B15C 20 13 FF              JSR   NNBL                     ;Get next non-blank character
1246 B15F 84 34                 STY   YSAV                     ;Save position in input buffer
1247 B161 DF 9A AE FF           CMP   >CHAR1,X                 ;
1248 B165 F0 0A                 BEQ   @1_2                     ;
1249 B167 DF AA AE FF           CMP   >CHAR3,X                 ;Test for long addressing mode
1250 B16B D0 1C                 BNE   @2                       ;
1251 B16D A9 40                 LDA   #$40                     ;
1252 B16F 85 3E                 STA   A2L                      ;Set bit 6 if long address
1253 B171              @1_2     EQU   *
1254 B171 C9 A4                 CMP   #'$'                     ;Ignore '$' if user entered it
1255 B173 D0 03                 BNE   @1_4                     ;
1256 B175 C8                    INY                            ;
1257 B176 80 11                 BRA   @2                       ;
1258 B178              @1_4     EQU   *
1259 B178 20 13 FF              JSR   NNBL                     ;Get next non-blank character
1260 B17B DF A2 AE FF           CMP   >CHAR2,X                 ;
1261 B17F F0 0A                 BEQ   @3                       ;
1262 B181 BF A2 AE FF           LDA   >CHAR2,X                 ;=0 then done with checking
1263 B185 F0 03                 BEQ   @4                       ;
1264 B187 A4 34                 LDY   YSAV                     ;Recall Y
1265 B189              @2       EQU   *
1266 B189 18                    CLC                            ;
1267 B18A              @4       EQU   *
1268 B18A 88                    DEY                            ;
1269 B18B              @3       EQU   *
1270 B18B 26 2C                 ROL   LMNEM                    ;Shift bit into format
1271 B18D E0 05                 CPX   #5                       ;Assume user's addr next if here
1272 B18F D0 36                 BNE   @6                       ;<>= then skip GETNUMFF
1273 B191 A5 3E                 LDA   A2L                      ;Save temp in A2L
1274 B193 48                    PHA                            ;
1275 B194 20 4B B2              JSR   GETNUMFF                 ;
1276 B197 8B                    PHB                            ;Save data bank register
1277 B198 20 82 F8              JSR   DBTOE1                   ;Switch in bank E1
1278 B19B 4E 42 01              LSR   |DIGITCNT                ;# of nybbles/2 = # of bytes
1279 B19E AB                    PLB                            ;Restore data bank register
1280 B19F 90 03                 BCC   @3_5                     ;Carry clear then even # of digits entered
1281 B1A1 20 BD B2              JSR   INCDIGITCNT              ;Compensate if odd # of digits entered
1282 B1A4              @3_5     EQU   *
1283 B1A4 68                    PLA                            ;Restore temp in A2L
1284 B1A5 85 3E                 STA   A2L                      ;
1285 B1A7 AF 42 01 E1           LDA   >DIGITCNT                ;
1286 B1AB 29 01                 AND   #1                       ;
1287 B1AD F0 04                 BEQ   @3_6
1288 B1AF A9 01                 LDA   #$01                     ;Set up 8 bit disassembler display mode
1289 B1B1 80 02                 BRA   @3_8                     ;
1290 B1B3              @3_6     EQU   *
1291 B1B3 A9 00                 LDA   #$00                     ;Set up 16 bit disassembler display mode
1292 B1B5              @3_8     EQU   *
1293 B1B5 8F 30 01 E1           STA   >MPVAL                   ;
1294 B1B9 8F 31 01 E1           STA   >XPVAL                   ;
1295 B1BD A5 3F                 LDA   A2H                      ;Test Hi byte of number gotten
1296 B1BF F0 01                 BEQ   @5                       ;
1297 B1C1 E8                    INX                            ;
1298 B1C2              @5       EQU   *
1299 B1C2 86 35                 STX   YSAV1                    ;Remember X for awhile
1300 B1C4 A2 05                 LDX   #5                       ;Restore X to 5
1301 B1C6 88                    DEY                            ;
1302 B1C7              @6       EQU   *
1303 B1C7 86 3D                 STX   A1H                      ;Preserve 'X' index
1304 B1C9 CA                    DEX                            ;Test next format
1305 B1CA 10 90                 BPL   @1                       ;Continue til all done
1306 B1CC
1307 B1CC A5 3E                 LDA   A2L                      ;Set bit 6 in length if long addressing
1308 B1CE 0F 42 01 E1           ORA   >DIGITCNT                ;Mask into counter
1309 B1D2 8F 42 01 E1           STA   >DIGITCNT                ; and save in counter.
1310 B1D6 84 34                 STY   YSAV                     ;update position
1311 B1D8 B9 00 02              LDA   IN,Y                     ;get next character
1312 B1DB C9 BB                 CMP   #$BB                     ;is it a ";"?
1313 B1DD F0 07                 BEQ   @8                       ;=>yes, skip comment
1314 B1DF C9 8D                 CMP   #$8D                     ;is it carriage return
1315 B1E1 F0 03                 BEQ   @8                       ;Done if carriage return
1316 B1E3 4C 20 B1              JMP   GOMINIERR2
1317 B1E6
1318 B1E6
1319 B1E6 4C FE AF     @8       JMP   GETOP                    ;get next opcode
1320 B1E9
1321 B1E9
1322 B1E9              LOOKASCFF EQU   *
1323 B1E9 70 08                 BVS   LOOKASCFF4               ;V=1 if continuing ASCII input
1324 B1EB B0 25                 BCS   DIGFF                    ;it was a digit
1325 B1ED C9 A0                 CMP   #$A0                     ;check for quote (')
1326 B1EF D0 20                 BNE   RTS6FF                   ;nope, return char
1327 B1F1 E2 40                 SEP   #$40                     ;Set V as indicator been here before
1328 B1F3              LOOKASCFF4 EQU   *
1329 B1F3 B9 00 02              LDA   IN,Y                     ;Get a character
1330 B1F6 C9 A7                 CMP   #''''                    ; quote terminates miniassembler ASCII input'
1331 B1F8 F0 14                 BEQ   @3                       ; BEQ LOOKASCFF5 ;
1332 B1FA C9 8D                 CMP   #$8D                     ;was it CR?
1333 B1FC D0 03                 BNE   @2                       ;<> = then continue
1334 B1FE B8                    CLV                            ;MUST clear 'v' on exit
1335 B1FF F0 5D                 BEQ   NXTCHRFF                 ;BEQ @3 ;BEQ GETNUMFF ;Go handle CR
1336 B201              @2       EQU   *
1337 B201 A2 07                 LDX   #7                       ;for shifting asc into A2L and A2H
1338 B203 20 BD B2              JSR   INCDIGITCNT              ;Causes DIGITCNT to be INC'ed 2 times
1339 B206 2F 34 01 E1           AND   >ASCFILTER               ;Filter the ASCII entered
1340 B20A C8                    INY                            ;advance index
1341 B20B D0 0B                 BNE   NXTBITFF                 ;=>(always) into A2L and A2H
1342 B20D 60                    RTS                            ;
1343 B20E
1344 B20E              @3       EQU   *
1345 B20E A9 99                 LDA   #$99                     ;Make monitor think we found a space
1346 B210 C8                    INY                            ;
1347 B211              RTS6FF   EQU   *
1348 B211 60                    RTS                            ;Back to caller with char in 'A'
1349 B212
1350 B212 A2 03        DIGFF    LDX   #$03                     ;Shift through 24 bits
1351 B214 0A                    ASL   A                        ; 
1352 B215 0A                    ASL   A                        ;GOT HEX DIGIT, 
1353 B216 0A                    ASL   A                        ; SHIFT INTO A2 
1354 B217 0A                    ASL   A                        ; 
1355 B218              NXTBITFF EQU   *
1356 B218 8B                    PHB                            ;MUST save and restore data bank register
1357 B219 20 82 F8              JSR   DBTOE1                   ;Change data bank register to ROL
1358 B21C              @1       EQU   *
1359 B21C 0A                    ASL   A                        ; 
1360 B21D C2 30                 REP   #$30                     ; in bank 00 and E1 at same time.
1361 B21F 26 3E                 ROL   A2L                      ;Do it in 16 bit mode
1362 B221 2E 40 01              ROL   |EXTENDBNK               ;
1363 B224 E2 30                 SEP   #$30                     ;Back to 8 bit land
1364 B226 CA                    DEX                            ;LEAVE X=$FF IF DIGFF 
1365 B227 10 F3                 BPL   @1                       ;  
1366 B229 AB                    PLB                            ;Back to original data bank
1367 B22A A5 31                 LDA   MONMODE
1368 B22C D0 13                 BNE   @12                      ;IF MONMODE IS ZERO, 
1369 B22E A2 01                 LDX   #$01                     ;Move 2 bytes
1370 B230              @11      EQU   *
1371 B230 B5 3E                 LDA   A2L,X                    ; THEN COPY A2 TO A1 AND A3 
1372 B232 95 3C                 STA   A1L,X
1373 B234 95 40                 STA   A3L,X
1374 B236 BF 40 01 E1           LDA   >EXTENDBNK,X             ;Copy for later
1375 B23A 9F 46 01 E1           STA   >EXTENDBNKS,X            ;Save in case doing '+' or '-'
1376 B23E CA                    DEX                            ;
1377 B23F F0 EF                 BEQ   @11                      ;Loop if =0
1378 B241              @12      EQU   *
1379 B241 E8                    INX   
1380 B242 F0 FD                 BEQ   @12                      ;Loop til 'X' <>= 0
1381 B244 20 BD B2              JSR   INCDIGITCNT              ;Increment digit count variable
1382 B247 70 AA                 BVS   LOOKASCFF4               ;V=1 then continue ASCII input
1383 B249 80 13                 BRA   NXTCHRFF
1384 B24B
1385 B24B              GETNUMFF EQU   *
1386 B24B B8                    CLV                            ;Indicate no ASCII being entered
1387 B24C C2 30                 REP   #$30                     ;Switch to 16 bit to save bytes
1388 B24E                       LONGA ON
1389 B24E A9 00 00              LDA   #$0000                   ;Clear variables to start
1390 B251                       LONGA OFF
1391 B251 85 3E                 STA   A2L                      ;
1392 B253 8F 40 01 E1           STA   >EXTENDBNK               ;Zero out extend byte/bank byte
1393 B257 E2 30                 SEP   #$30                     ;Bank to 8 bit land
1394 B259 8F 42 01 E1           STA   >DIGITCNT                ;Zero # of digits entered count
1395 B25D AA                    TAX                            ;MUST make X=0 to start
1396 B25E              NXTCHRFF EQU   *
1397 B25E 20 CA FC              JSR   UPMON                    ;Read/upshift character if necessary
1398 B261 49 B0                 EOR   #$B0
1399 B263 C9 0A                 CMP   #$0A
1400 B265 90 AB                 BCC   DIGFF                    ;BR IF HEX DIGIT 
1401 B267 08                    PHP                            ;Preserve V status
1402 B268 69 88                 ADC   #$88
1403 B26A 28                    PLP                            ;Restore V status
1404 B26B C9 FA                 CMP   #$FA
1405 B26D 4C E9 B1              JMP   LOOKASCFF                ;check for ASCII input
1406 B270
1407 B270
1408 B270              * The following routines are used to set up the source bank 
1409 B270              * and the higher bank (extend) for the command with '.' or ':'.
1410 B270              * It searches through for command with syntax '/', if found 
1411 B270              * for the first time, then treats as source bank and also set
1412 B270              * the extend bank equals to the source bank.  Then it countines 
1413 B270              * searching for another '/', if found then set it for extended
1414 B270              * bank byte.  These banks byte setting are mainly used in the
1415 B270              * related cross bank stuff.
1416 B270              * Example: aa<bb1/xxxx.yyyyz, same bank filling
1417 B270              *          aa<bb1/xxxx.bb2/yyyyz, cross bank filling
1418 B270              * In any time, if higher address is less than the specified 
1419 B270              * source bank then handle only the first byte and quit.
1420 B270
1421 B270
1422 B270              XGETNUM  EQU   *                        ;MONZ enters here
1423 B270 A4 34                 LDY   YSAV                     ;Get where MONZ is in input buffer
1424 B272              XGETNUMFF EQU   *
1425 B272 20 4B B2              JSR   GETNUMFF
1426 B275 C9 A8                 CMP   #$A8                     ;If '/' ($A8='/' EOR #$B0+$89)(set bank)?
1427 B277 D0 98                 BNE   RTS6FF                   ;
1428 B279 A5 31                 LDA   MONMODE                  ;Leave bank number alone if in a mode
1429 B27B D0 0C                 BNE   @1
1430 B27D A5 3E                 LDA   A2L
1431 B27F 8F 3E 01 E1           STA   >BANKS                   ;Make new source bank
1432 B283 8F A7 01 E1           STA   >HIGHBANK                ;Set higher bank = source bk if no high bank specified
1433 B287 80 E9                 BRA   XGETNUMFF                ;Do NOT exit yet
1434 B289              @1       EQU   *
1435 B289 C9 AE                 CMP   #$AE                     ;Check for mode '.'
1436 B28B F0 04                 BEQ   @2                       ;Bra if yes               
1437 B28D C9 BA                 CMP   #$BA                     ;Is it ':' ?
1438 B28F D0 E1                 BNE   XGETNUMFF                ;Bra if not
1439 B291              @2       EQU   *
1440 B291 A5 3E                 LDA   A2L                      ;Store as cross bank usage
1441 B293 8F A7 01 E1           STA   >HIGHBANK                ;
1442 B297 80 D9                 BRA   XGETNUMFF
1443 B299
1444 B299
1445 B299              MOVINST1 EQU   *                        ;get instruction length
1446 B299 A5 40                 LDA   A3L                      ;Move address from A3L/H to A2L/H
1447 B29B 85 3E                 STA   A2L                      ; since PCYTOA3 uses A3L/H.
1448 B29D A5 41                 LDA   A3H                      ;
1449 B29F 85 3F                 STA   A2H                      ;
1450 B2A1              @2       EQU   *
1451 B2A1 A4 2F                 LDY   LENGTH                   ;How many bytes left to move-1?
1452 B2A3 C0 03                 CPY   #$03                     ;Y=3 if bank # entered
1453 B2A5 F0 05                 BEQ   @4                       ;
1454 B2A7 B9 3D 00              LDA   |A1H,Y                   ;Get address byte
1455 B2AA 80 04                 BRA   @6                       ;Go deposit it into memory
1456 B2AC
1457 B2AC              @4       EQU   *
1458 B2AC AF 40 01 E1           LDA   >EXTENDBNK               ;Bank number
1459 B2B0              @6       EQU   *
1460 B2B0 48                    PHA   
1461 B2B1 20 E3 AA              JSR   PCYTOA3                  ;Find location
1462 B2B4 68                    PLA   
1463 B2B5 20 EC B7              JSR   STORBYTE                 ; store byte.
1464 B2B8 C6 2F                 DEC   LENGTH
1465 B2BA 10 E5                 BPL   @2                       ;
1466 B2BC 60                    RTS                            ;Back to caller
1467 B2BD
1468 B2BD
1469 B2BD              INCDIGITCNT EQU   *
1470 B2BD 8B                    PHB                            ;Save data bank register
1471 B2BE 20 82 F8              JSR   DBTOE1                   ;Change data bank register
1472 B2C1 EE 42 01              INC   |DIGITCNT                ;Inc digit counter
1473 B2C4 AB                    PLB                            ;Restore data bank register
1474 B2C5 60                    RTS                            ;Back to caller
1475 B2C6
1476 B2C6
1477 B2C6              XSTOR    EQU   *                        ;Monitor immediate mode store routine
1478 B2C6 A2 BA                 LDX   #$BA                     ;Stay in store mode
1479 B2C8 86 31                 STX   MONMODE                  ;
1480 B2CA A6 40                 LDX   A3L                      ;Move address to PCL/PCH
1481 B2CC 86 3A                 STX   PCL                      ;
1482 B2CE A6 41                 LDX   A3H                      ;
1483 B2D0 86 3B                 STX   PCH                      ;
1484 B2D2              HEXENTRY3 EQU   *
1485 B2D2 EB                    XBA                            ;Save 'A'
1486 B2D3 AF 42 01 E1           LDA   >DIGITCNT                ;# of nybbles/2 = # of bytes
1487 B2D7 4A                    LSR   A                        ;
1488 B2D8 90 01                 BCC   @1                       ;Carry clear then even # of digits entered
1489 B2DA 1A                    INC   A                        ;Compensate if odd # of digits entered
1490 B2DB              @1       EQU   *
1491 B2DB C9 05                 CMP   #$05                     ;<5 allowed only
1492 B2DD 90 02                 BCC   @2                       ;
1493 B2DF A9 04                 LDA   #$04                     ;Limit to last 4 characters entered
1494 B2E1              @2       EQU   *
1495 B2E1 3A                    DEC   A                        ;LENGTH=number of bytes-1 for MOVINST1
1496 B2E2 AA                    TAX                            ;Save length
1497 B2E3 85 2F                 STA   LENGTH                   ;Save length for MOVEINST1.
1498 B2E5 EB                    XBA                            ;Recall 'A'
1499 B2E6 C9 C6                 CMP   #$C6                     ;Test for return ($8D EOR #$B0 + $89)
1500 B2E8 08                    PHP                            ;Save 'z' status
1501 B2E9 DA                    PHX                            ;Save length+1 on stack
1502 B2EA A5 3E                 LDA   A2L                      ;Shift bytes down for MOVINST1
1503 B2EC 85 3D                 STA   A1H                      ;Byte 0 location for MOVINST1
1504 B2EE A5 3F                 LDA   A2H                      ;Byte 1 location for MOVINST1
1505 B2F0 85 40                 STA   A3L                      ;
1506 B2F2 AF 40 01 E1           LDA   >EXTENDBNK               ;Byte 2 location for MOVINST1
1507 B2F6 85 41                 STA   A3H                      ;
1508 B2F8 AF 41 01 E1           LDA   >EXTENDBNK+1             ;Byte 3 (extend byte) loc for MOVINST1
1509 B2FC 8F 40 01 E1           STA   >EXTENDBNK               ;
1510 B300 C2 20                 REP   #$20
1511 B302                       LONGA ON
1512 B302 A5 40                 LDA   A3L                      ;Move A3 to A2 (16 bit)
1513 B304 85 3E                 STA   A2L
1514 B306 A5 2F                 LDA   LENGTH
1515 B308 29 FF 00              AND   #$00FF                   ;Mask off unwanted high byte 
1516 B30B 18                    CLC   
1517 B30C 65 3A                 ADC   PCL                      ;16 bit add
1518 B30E B0 23                 BCS   @8                       ;Bra if bank crossing   
1519 B310 E2 20                 SEP   #$20
1520 B312                       LONGA OFF
1521 B312 20 99 B2              JSR   MOVINST1                 ;Store data
1522 B315              @15      EQU   *
1523 B315 68                    PLA                            ;Get length for FIXPC
1524 B316 85 2F                 STA   LENGTH                   ;
1525 B318 A5 3B                 LDA   PCH                      ;Get high part of pc
1526 B31A 49 FF                 EOR   #$FF                     ;Already at $ff
1527 B31C D0 10                 BNE   @3                       ;BRA if not 
1528 B31E A5 3A                 LDA   PCL                      ;Save old PCL               
1529 B320 48                    PHA   
1530 B321 20 7B AC              JSR   FIXPC                    ;A3=PC+LENGTH
1531 B324 68                    PLA                            ;Get back old PCL
1532 B325 C5 3A                 CMP   PCL                      ;Compare with new PCL
1533 B327 90 08                 BCC   @4                       ;Bra if old PCL < new PCL, fine
1534 B329 20 6B B3              JSR   INCBANKS
1535 B32C 80 03                 BRA   @4
1536 B32E              @3       EQU   *
1537 B32E 20 7B AC              JSR   FIXPC                    ;Update PC
1538 B331              @4       EQU   *
1539 B331 28                    PLP                            ;Test if last entry or not
1540 B332 60                    RTS                            ;Back to caller
1541 B333
1542 B333              @8       EQU   *                        ;Cross bank processing
1543 B333 E2 20                 SEP   #$20                     ;Back to 16 bit land
1544 B335                       LONGA OFF
1545 B335              @9       EQU   *
1546 B335 AF 3E 01 E1           LDA   >BANKS                   ;Need to preserve BANKS          
1547 B339 48                    PHA   
1548 B33A              @99      EQU   *
1549 B33A 68                    PLA                            ;Each loop use its original BANKS
1550 B33B 48                    PHA   
1551 B33C 8F 3E 01 E1           STA   >BANKS                   ;Get back 
1552 B340 A4 2F                 LDY   LENGTH                   ;How many bytes left to move-1?
1553 B342 C0 03                 CPY   #$03                     ;If Y=3 then 4 bytes entered
1554 B344 F0 05                 BEQ   @10                      ;Bra to get the highest byte
1555 B346 B9 3D 00              LDA   |A1H,Y                   ;Else use index to locate byte
1556 B349 80 04                 BRA   @11                      ;Go on
1557 B34B              @10      EQU   *
1558 B34B AF 40 01 E1           LDA   >EXTENDBNK               ;Get the highest byte      
1559 B34F              @11      EQU   *
1560 B34F 48                    PHA                            ;Temp save 
1561 B350 20 E3 AA              JSR   PCYTOA3                  ;Find location to save to
1562 B353 A5 40                 LDA   A3L                      ;Chk for crossing bank
1563 B355 29 F0                 AND   #$F0                     ;If cross bank, then high nibbles of A3L is zero
1564 B357 D0 03                 BNE   @12                      ;BRA if not yet cross bank
1565 B359 20 6B B3              JSR   INCBANKS
1566 B35C              @12      EQU   *
1567 B35C 68                    PLA                            ;Get back the user's keyin byte
1568 B35D 20 EC B7              JSR   STORBYTE                 ;Store it
1569 B360 C6 2F                 DEC   LENGTH                   ;
1570 B362 10 D6                 BPL   @99                      ;Continue in loop
1571 B364 68                    PLA                            ;Else get back the preserved BANKS
1572 B365 8F 3E 01 E1           STA   >BANKS                   ;Store back
1573 B369 80 AA                 BRA   @15                      ;Exit to adjust for new PC, FIXPC
1574 B36B
1575 B36B              INCBANKS EQU   *
1576 B36B AF 3E 01 E1           LDA   >BANKS
1577 B36F 1A                    INC   A
1578 B370 8F 3E 01 E1           STA   >BANKS
1579 B374 60                    RTS   
1580 B375
1581 B375
